﻿{$reference MathNet.Numerics.dll}
// Подключаем пространство имен для линейной алгебры:
uses MathNet.Numerics.LinearAlgebra; 

type
  TMatrix = Matrix<real>;
  TVector = Vector<real>;
  
// общая длина сукна в аршинах:
const LENGTH = 138;
// общая стоимость сукна в рублях:
COST = 540;


// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   // левая часть уравнения:     
   var left := TMatrix
              .Build
              .DenseOfRowArrays(new real[] (1, 1),
                                new real[] (5, 3));
   // правая часть уравнения:  
   var right := TVector
               .Build
               .DenseOfArray(new real[] (LENGTH, COST));
   
   // решаем систему уравнений:
   var res := left.Solve(right);
   // печатаем ответ:
   WriteLn(' Синего сукна:  ', res[0]);
   WriteLn(' Чёрного сукна: ', res[1]);  
   Writeln;    
end;


begin
   Writeln(' Репетитор СЛУ');
   Writeln; 
   Solve();
end.
